package cn.com.duiba.tuia.core.api.enums;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * ClassName: ResourceTagsTypeEnum <br/>
 * Function: 资源对应标签类型. <br/>
 * date: 2017年7月31日 下午4:41:03 <br/>
 *
 * @author chencheng
 * @version
 */
public enum TagsNumEnum {

    /** 广告标签 */
    ADVERT_TAG("20000", "广告标签"),
    
    /** 活动标签 */
    ACTIVITY_TAG("10000", "活动标签"),
    
    /** 屏蔽标签 */
    BANNED_TAG("30000", "屏蔽标签"),
    
    /** 推广链接标签 */
    PROMOTEURL("40000", "推广链接标签"),

    /** 素材标签 */
    MATERIAL("50000", "素材标签"),
    
    /** 分析标签 */
    ANALYSIS("60000", "分析标签");

    private String desc;

    private String code;

    TagsNumEnum(String code, String desc) {
        this.desc = desc;
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public String getCode() {
        return code;
    }

    private static Map<String, TagsNumEnum> enumMap = Maps.newHashMap();
    static {
        for (TagsNumEnum it : TagsNumEnum.values()) {
            enumMap.put(it.getCode(), it);
        }
    }

    public static TagsNumEnum getByName(String code) {
        return enumMap.get(code);
    }
}
