package cn.com.duiba.tuia.core.api.enums.statistics;

/**
 * @Author:zhangmeng
 * @Date:2018-06-13
 * @Function:全局流量配置配置项
 */
public enum GlobalConfigItemEnum {
    /**
     * 配置项：1-权重；2-发券顺序；3-投放时段；4-地区；5-操作系统',
     */
    ADVERT_WEIGHT(1,"advertWeight"),

    JOIN_NUMS(2,"joinNums"),

    PUSH_DATE(3,"pushDate"),

    REGION_IDS(4,"regionIds"),

    PLAT_FORM(5,"platform");

    private Integer code;

    private String name;

    private GlobalConfigItemEnum(Integer code,String name){
        this.code=code;
        this.name=name;
    }

    public static GlobalConfigItemEnum getNameByCode(Integer code){
        for(GlobalConfigItemEnum item:GlobalConfigItemEnum.values()){
            if(item.getCode().equals(code)){
                return item;
            }
        }
        return null;
    }

    public static GlobalConfigItemEnum getCodeByName(String name){
        for(GlobalConfigItemEnum item:GlobalConfigItemEnum.values()){
            if(item.getName().equals(name)){
                return item;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}
