package cn.com.duiba.tuia.core.api.remoteservice.jfsite;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.jfsite.JfAlarmFormDTO;
import cn.com.duiba.tuia.core.api.dto.jfsite.JfAlarmPersonDTO;
import cn.com.duiba.tuia.core.api.dto.jfsite.JfAlarmQueryDTO;

import java.util.List;

/**
 * [JF建站]域名告警配置 RemoteService
 * @author lijicong
 * @since 2020-07-24
 */
@AdvancedFeignClient
public interface RemoteJfAlarmService {

    /**
     * 多条件查询
     * @param queryDTO
     * @return
     */
    List<JfAlarmPersonDTO> queryPersonList(JfAlarmQueryDTO queryDTO);

    /**
     * 保存
     * @param formDTO
     * @return
     */
    boolean savePerson(JfAlarmFormDTO formDTO);

    /**
     * 批量保存人员
     * @param formDTO
     * @return
     */
    boolean saveBatchPerson(JfAlarmFormDTO formDTO);

    /**
     * 删除告警人员
     * @param formDTO
     * @return
     */
    boolean deletePerson(JfAlarmFormDTO formDTO);

}