package cn.com.duiba.tuia.core.api.dto.land;

import cn.com.duiba.tuia.core.api.dto.BaseDto;

import java.math.BigDecimal;

/**
 * @author Wangpf
 * @description  单次诊断落地页对应资源详情
 * @date 2019/7/22 16:54
 */
public class LandPageDiagnosisDetailDto extends BaseDto {

    /**
     * 诊断结果ID
     */
    private long diagnosisId;

    /**
     * 当前资源名称 js css link etc
     */
    private String name;

    /**
     * 当前资源加载时长
     */
    private BigDecimal loadTime;

    /**
     * 当前资源大小
     */
    private BigDecimal pageSize;

    /**
     * 当前资源对应的链接
     */
    private String url;


    public LandPageDiagnosisDetailDto() {
    }

    public LandPageDiagnosisDetailDto(long diagnosisId, String name, BigDecimal loadTime, BigDecimal pageSize, String url) {
        this.diagnosisId = diagnosisId;
        this.name = name;
        this.loadTime = loadTime;
        this.pageSize = pageSize;
        this.url = url;
    }

    public long getDiagnosisId() {
        return diagnosisId;
    }

    public void setDiagnosisId(long diagnosisId) {
        this.diagnosisId = diagnosisId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigDecimal getLoadTime() {
        return loadTime;
    }

    public void setLoadTime(BigDecimal loadTime) {
        this.loadTime = loadTime;
    }

    public BigDecimal getPageSize() {
        return pageSize;
    }

    public void setPageSize(BigDecimal pageSize) {
        this.pageSize = pageSize;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

}
