/**
 * Project Name:tuia-core-api<br>
 * File Name:ReqGetAdvertiserDataDto.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.dto.req<br>
 * Date:2016年9月5日下午4:02:27<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.core.api.dto.req;

import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

import cn.com.duiba.tuia.core.api.dto.BaseDateQueryDto;

/**
 * ClassName: ReqGetAdvertiserDataDto <br/>
 * date: 2016年9月5日 下午4:02:27 <br/>
 * .
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
public class ReqGetAccountStatisticsDataDto extends BaseDateQueryDto {

    /** The Constant serialVersionUID. @since JDK 1.6 */
    private static final long serialVersionUID = 3637375453495547552L;

    /** 广告主名称. */
    private String            companyName;

    /** 代理商ID. */
    private Long              agentId;

    //最顶级代理商ID
    private Long topAgentId;

    /** 广告主ID集合(用于广告主名称模糊查询). */
    private List<Long>        advertiserIds;

    /** 邮箱. */
    private String            email;

    private Integer effectiveMainType;

    public Integer getEffectiveMainType() {
        return effectiveMainType;
    }

    public void setEffectiveMainType(Integer effectiveMainType) {
        this.effectiveMainType = effectiveMainType;
    }

    public Long getTopAgentId() {
        return topAgentId;
    }

    public void setTopAgentId(Long topAgentId) {
        this.topAgentId = topAgentId;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    /**
     * agentId.
     *
     * @return the agentId
     * @since JDK 1.6
     */
    public Long getAgentId() {
        return agentId;
    }

    /**
     * agentId.
     *
     * @param agentId the agentId to set
     * @since JDK 1.6
     */
    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }

    /**
     * Gets the advertiser ids.
     *
     * @return the advertiser ids
     */
    public List<Long> getAdvertiserIds() {
        return advertiserIds;
    }

    /**
     * Sets the advertiser ids.
     *
     * @param advertiserIds the advertiser ids
     */
    public void setAdvertiserIds(List<Long> advertiserIds) {
        this.advertiserIds = advertiserIds;
    }

    /**
     * Gets the email.
     *
     * @return the email
     */
    public String getEmail() {
        return email;
    }

    /**
     * Sets the email.
     *
     * @param email the email
     */
    public void setEmail(String email) {
        this.email = email;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
