package cn.com.duiba.tuia.core.api.enums.advert;

/**
 * Created by huangch on 2019/3/15 18:21
 * description: 1-操作系统、2-网络类型、3-运营商、4-设备品牌、5-设备价值
 *
 * @since JDK 1.6
 */
public enum OrientationSynTypes {

    XX(0, "美鲜牛奶"),

    OS(1, "操作系统"),

    NET(2, "网络类型"),

    OP(3, "运营商"),

    BD(4, "设备品牌"),

    PR(5, "设备价值"),

    FW(6, "屏蔽流量"),

    DR(7,"定向人群");



    private Integer type;

    private String desc;

    OrientationSynTypes(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static OrientationSynTypes getByType(Integer type) {
        if (type == null) {
            return XX;
        }
        for (OrientationSynTypes types : values()) {
            if (types.getType().equals(type)) {
                return types;
            }
        }
        return XX;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
