package cn.com.duiba.tuia.core.api.remoteservice;

import java.util.List;

import org.springframework.web.bind.annotation.RequestMapping;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.AdvertPlanPeriodDto;
import cn.com.duiba.tuia.core.api.dto.req.orientPkg.AdvertPlanPeriodReq;
import cn.com.duiba.wolf.dubbo.DubboResult;

@AdvancedFeignClient
public interface RemoteAdvertPlanPeriodsBackendService {

	/**
     * 新增投放时段记录.
     *
     * @param advertId 广告ID
     * @param startHour 开始时段
     * @param endHour 结束时段
     * @param launchLimit 投放上限
     * @param advertPackageId 定向包配置ID
     * @return the int
     * @throws TuiaCoreException the tuia exception
     */
	@Deprecated
    @RequestMapping("/insert1")
    DubboResult<Boolean> insert(Long advertId, String startHour, String endHour, Integer launchLimit, Long advertPackageId);
	/**
     * 新增投放时段记录.
     *
     */
    @RequestMapping("/insert2")
    DubboResult<Boolean> insert(AdvertPlanPeriodDto dto);

    /**
     * 根据广告ID/定向包投放ID查询所有投放时段.
     *
     * @param advertId 广告ID
     * @param advertPackageId 定向包配置ID
     * @return 投放时段列表
     * @throws TuiaCoreException the tuia exception
     */
    DubboResult<List<AdvertPlanPeriodDto>> selectByAdvertId(Long advertId, Long advertPackageId);

    /**
     * 更新投放时段信息.
     *
     * @param periodId the period id
     * @param startHour 开始时段
     * @param endHour 结束时段
     * @param launchLimit 投放上限
     * @return the int
     * @throws TuiaCoreException the tuia exception
     */
    @RequestMapping("/update1")
    DubboResult<Boolean> update(Long periodId, String startHour, String endHour, Integer launchLimit);
    /**
     * 更新投放时段信息.
     */
    @RequestMapping("/update2")
    DubboResult<Boolean> update(AdvertPlanPeriodDto dto);

    /**
     * 删除投放时段.
     *
     * @param periodId 时段ID
     * @return the int
     * @throws TuiaCoreException the tuia exception
     */
    DubboResult<Boolean> delete(Long periodId);
    
    /**
     * 根据定向包配置ID批量查询
     * @param packageIds
     * @param advertId
     * @return
     * @throws TuiaCoreException
     * @since JDK 1.6
     */
    DubboResult<List<AdvertPlanPeriodDto>> selectByPackageIds(Long advertId, List<Long> packageIds);
	
    /**
	 * 
	 * selectByQuery:(条件查询时段信息). <br/>
	 *
	 * @author chencheng
	 * @param query
	 * @return
	 * @since JDK 1.8
	 */
    List<AdvertPlanPeriodDto> selectByQuery(AdvertPlanPeriodReq query);
}
