/**
 * Project Name:tuia-core-api<br>
 * File Name:RemoteItemService.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.remoteservice<br>
 * Date:2016年11月9日上午11:12:59<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.core.api.remoteservice;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName: RemoteItemService <br/>
 * date: 2016年11月9日 上午11:12:59 <br/>
 * .
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteItemService {

    /**
     * 获取所有的ItemId列表.<br>
     * [使用说明]<br>
     * <ol>
     * <li>获取所有关联推啊广告的兑吧ItemId列表</li>
     * <li>内部使用缓存</li>
     * </ol>
     *
     * @return the all itme ids
     */
    DubboResult<List<Long>> getAllItmeIds();

    /**
     * 根据Itemid查询关联的广告ID.
     *
     * @param itemId the item id
     * @return the advert id by itme id
     */
    DubboResult<Long> getAdvertIdByItmeId(long itemId);

    /**
     * 关闭兑吧兑换项.<br>
     * [使用说明]
     * <ol>
     * <li>当推啊广告发券扣费，发现广告每日预算不足时， 关闭推啊广告所关联的兑吧兑换项，不再发券</li>
     * </ol>
     *
     * @param advertId the advert id
     * @return the advert id by itme id
     */
    DubboResult<Boolean> closeDuiBaItmeByAdvertId(long advertId);
}
