package cn.com.duiba.tuia.core.api.remoteservice.advert;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.AdvertCheckRecordDto;
import cn.com.duiba.tuia.core.api.dto.advert.req.ReqAdvertsCheckRecord;

/**
 * Created by 李健 on 2019-04-29 14:02.
 */
@AdvancedFeignClient
public interface RemoteAdvertCheckRecordService {

    /**
     * 分页查询审核记录数量
     */
    Integer queryPageCount(ReqAdvertsCheckRecord param);

    /**
     * 分页查询审核记录数据
     */
    List<AdvertCheckRecordDto> pageAdvertCheckRecordList(ReqAdvertsCheckRecord param);

    /**
     * 根据广告id等条件查询最近一次审核通过的审核记录数据
     */
    AdvertCheckRecordDto  getLastPassByParam(Long advertId,String startDate);

    /**
     * 根据广告id等条件查询最近一次审核记录数据
     */
    AdvertCheckRecordDto  getLastAdvertCheckRecord(Long advertId);

    /**
     * 根据广告id条件查询最近二次次审核通过的审核记录数据
     */
    List<AdvertCheckRecordDto>  getLastTwoPassByParam(Long advertId);
}
