package cn.com.duiba.tuia.core.api.remoteservice.baiqi;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.rsp.baiqi.BaiQiAdvertDetailDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteBaiQiService {

    /**
     * 操作账户余额接口
     *
     * @param baiqiTradeNo 百奇交易号
     * @param tradeType    交易类型 1- 划账 2-回拨
     * @param accountId    被操作的帐号id
     * @param amount       操作金额
     * @return 操作结果 true-成功 false-失败
     */
    Boolean allocateAmount(String baiqiTradeNo, int tradeType, Long accountId, Long amount);

    /**
     * 检查交易
     *
     * @param baiqiTradeNo 百奇交易号
     * @return 操作结果 true-成功 false-失败
     */
    Boolean checkTrade(String baiqiTradeNo);

    /**
     * 百奇将启动一个任务，每隔5分钟向推啊拉取百奇代理下的所有广告主广告计划相关的明细
     * @param startTime
     * @param endTime
     * @return
     */
    List<BaiQiAdvertDetailDto> findBaiQiDetail(String startTime, String endTime);


}
