package cn.com.duiba.tuia.core.api.dto.company_dynamic;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * @author wangting
 * @version 1.0
 * @ClassName: CompanyDynamicReq
 * Function: 公司动态请求实体
 * Date:     2019/5/17 0017 上午 9:51
 */
@ApiModel("公司动态请求实体")
public class DuibaCompanyDynamicDto  extends BaseCompanyDynamicDto implements Serializable {


    private static final long serialVersionUID = 2817220869529940805L;

    @ApiModelProperty("公司动态的状态：0-下线 1-草稿 2-发布")
    private Integer status;


    @ApiModelProperty("动态类型 0-公告通函 1-新闻稿 2-公司动态")
    private Integer type;

    @ApiModelProperty("语言版本 0-简体， 1-繁体 2-英语")
    private List<Integer> languageVersion;

    @ApiModelProperty("上传文件CND路径")
    private String fileUrl;

    @ApiModelProperty("上传文件名")
    private String fileName;

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
    public List<Integer> getLanguageVersion() {
        return languageVersion;
    }

    public void setLanguageVersion(List<Integer> languageVersion) {
        this.languageVersion = languageVersion;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getFileUrl() {
        return fileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }
}
