/**
 * Project Name:tuia-core-api<br>
 * File Name:Tag.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.dto<br>
 * Date:2016年9月27日下午7:22:11<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.core.api.dto.req.tag;

import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

import cn.com.duiba.tuia.core.api.dto.BaseDto;

/**
 * ClassName: NewTagDto <br/>
 * Function: 新标签. <br/>
 * date: 2018年1月15日 上午11:58:34 <br/>
 *
 * @author chencheng
 * @version
 * @since JDK 1.8
 */
public class ReqNewTagDto extends BaseDto {

    private static final long serialVersionUID = -7637594009919101061L;

    /** 标签名称 */
    private String            tagName;

    /** 标签编号 */
    private String            tagNum;

    /** 标签编号集合 */
    private List<String>      tagNums;

    /** 上级节点TagNum */
    private String            parentTagNum;

    /** 标签对应的广告id */
    private Integer           tagLevel;

    /** id集合 */
    private List<Long>        ids;

    public ReqNewTagDto(String tagName, String tagNum, List<String> tagNums, String parentTagNum, Integer tagLevel,
                        List<Long> ids) {
        super();
        this.tagName = tagName;
        this.tagNum = tagNum;
        this.tagNums = tagNums;
        this.parentTagNum = parentTagNum;
        this.tagLevel = tagLevel;
        this.ids = ids;
    }

    public ReqNewTagDto(List<Long> ids) {
        super();
        this.ids = ids;
    }

    public ReqNewTagDto() {
        super();
    }

    /**
     * ids.
     *
     * @return the ids
     * @since JDK 1.8
     */
    public List<Long> getIds() {
        return ids;
    }

    /**
     * ids.
     *
     * @param ids the ids to set
     * @since JDK 1.8
     */
    public void setIds(List<Long> ids) {
        this.ids = ids;
    }

    /**
     * tagName.
     *
     * @return the tagName
     * @since JDK 1.8
     */
    public String getTagName() {
        return tagName;
    }

    /**
     * tagName.
     *
     * @param tagName the tagName to set
     * @since JDK 1.8
     */
    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    /**
     * tagNum.
     *
     * @return the tagNum
     * @since JDK 1.8
     */
    public String getTagNum() {
        return tagNum;
    }

    /**
     * tagNum.
     *
     * @param tagNum the tagNum to set
     * @since JDK 1.8
     */
    public void setTagNum(String tagNum) {
        this.tagNum = tagNum;
    }

    /**
     * tagNums.
     *
     * @return the tagNums
     * @since JDK 1.8
     */
    public List<String> getTagNums() {
        return tagNums;
    }

    /**
     * tagNums.
     *
     * @param tagNums the tagNums to set
     * @since JDK 1.8
     */
    public void setTagNums(List<String> tagNums) {
        this.tagNums = tagNums;
    }

    /**
     * parentTagNum.
     *
     * @return the parentTagNum
     * @since JDK 1.8
     */
    public String getParentTagNum() {
        return parentTagNum;
    }

    /**
     * parentTagNum.
     *
     * @param parentTagNum the parentTagNum to set
     * @since JDK 1.8
     */
    public void setParentTagNum(String parentTagNum) {
        this.parentTagNum = parentTagNum;
    }

    /**
     * tagLevel.
     *
     * @return the tagLevel
     * @since JDK 1.8
     */
    public Integer getTagLevel() {
        return tagLevel;
    }

    /**
     * tagLevel.
     *
     * @param tagLevel the tagLevel to set
     * @since JDK 1.8
     */
    public void setTagLevel(Integer tagLevel) {
        this.tagLevel = tagLevel;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
