package cn.com.duiba.tuia.core.api.enums.advert;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * ClassName:CrowdInterestEnum <br/>
 * Function: 人群兴趣点枚举. <br/>
 * Date:     2018年3月21日 上午10:18:26 <br/>
 * @author   chencheng
 * @version  
 * @since    JDK 1.8
 * @see 	 
 */
public enum CrowdInterestEnum {
    
    /** 网购 */
    SHOPPING("shopping", "网购"),

    /** 金融理财 */
    FINANCE("finance", "金融理财"),
    
    /** 健康养生 */
    HEALTH("health", "健康养生"),

    /** 棋牌游戏 */
    POKER("poker", "棋牌游戏"),

    /** 大型游戏 */
    BIGGAME("biggame", "大型游戏");

    private String desc;

    private String code;

    CrowdInterestEnum(String code, String desc) {
        this.desc = desc;
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public String getCode() {
        return code;
    }

    private static Map<String, CrowdInterestEnum> enumMap = Maps.newHashMap();
    static {
        for (CrowdInterestEnum it : CrowdInterestEnum.values()) {
            enumMap.put(it.getCode(), it);
        }
    }

    public static CrowdInterestEnum getByName(String code) {
        return enumMap.get(code);
    }
}

