package cn.com.duiba.tuia.core.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.advert.AdvertKeyWordEstimateTaskDataInfoDTO;
import cn.com.duiba.tuia.core.api.dto.advert.AdvertKeyWordEstimateTaskInfoDTO;
import cn.com.duiba.tuia.core.api.dto.advert.AdvertKeyWordEstimateTaskQueryDTO;

import java.util.List;

@AdvancedFeignClient
public interface RemoteKeywordsService {

    /**
     * 根据广告位查询关键词屏蔽列表
     * @param slots
     * @return
     */
    List<Long> getSlotKeywordsShieldList(List<Long> slots);

    /**
     * 创建预估任务
     * @param advertKeyWordEstimateTaskInfoDTO
     * @return
     */
    Long createTask(AdvertKeyWordEstimateTaskInfoDTO advertKeyWordEstimateTaskInfoDTO);

    /**
     * 预估任务分页查询
     * @param advertKeyWordEstimateTaskQueryDTO
     * @return
     */
    List<AdvertKeyWordEstimateTaskInfoDTO> pageQueryKeyWordsAdvert(AdvertKeyWordEstimateTaskQueryDTO advertKeyWordEstimateTaskQueryDTO);

    /**
     * 预估任务查询总数
     * @param advertKeyWordEstimateTaskQueryDTO
     * @return
     */
    Integer queryCountKeyWordsAdvert(AdvertKeyWordEstimateTaskQueryDTO advertKeyWordEstimateTaskQueryDTO);

    /**
     * 根据指定条件查询任务数
     * @param advertKeyWordEstimateTaskQueryDTO
     * @return
     */
    Integer queryTaskCountByConditions(AdvertKeyWordEstimateTaskQueryDTO advertKeyWordEstimateTaskQueryDTO);

    /**
     * 导出任务数据
     * @param id
     * @return
     */
    List<AdvertKeyWordEstimateTaskDataInfoDTO> getTaskDataById(Long id);

}
