/**
 * Project Name:tuia-advert-center-api
 * File Name:RemoteValidFreeAdvertService.java
 * Package Name:cn.com.duiba.tuia.core.api.remoteservice
 * Date:2018年2月9日上午11:18:53
 * Copyright (c) 2018, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.core.api.remoteservice;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.req.advert.ReqValidFreeAdvertDto;
import cn.com.duiba.tuia.core.api.dto.rsp.advert.ValidFreeAdvertOrderDto;

/**
 * ClassName:RemoteValidFreeAdvertService <br/>
 * Function: 免费券有效排序查询. <br/>
 * Date:     2018年2月9日 上午11:18:53 <br/>
 * @author   chencheng
 * @version  
 * @since    JDK 1.8
 * @see 	 
 */
@AdvancedFeignClient
public interface RemoteValidFreeAdvertService {

    /**
     * 
     * selectValidFreeAgentAdvert:(条件查询免费代理商、广告). <br/>
     *
     * @author chencheng
     * @param query
     * @return
     * @since JDK 1.8
     */
    List<ValidFreeAdvertOrderDto> selectValidFreeAgentAdvert(ReqValidFreeAdvertDto query);
    
    /**
     * 
     * selectValidFreeAdvert:(查询所有有效的、免费代理商). <br/>
     *
     * @author chencheng
     * @param query
     * @return
     * @since JDK 1.8
     */
    List<ValidFreeAdvertOrderDto> selectValidFreeAgent(ReqValidFreeAdvertDto query);
    
    /**
     * 
     * selectValidFreeAdvert:(查询所有有效的、免费广告). <br/>
     *
     * @author chencheng
     * @param query
     * @return
     * @since JDK 1.8
     */
    List<ValidFreeAdvertOrderDto> selectValidFreeAdvert(ReqValidFreeAdvertDto query);

    /**
     * 
     * updateByAdvertId:(更新免费广告排序). <br/>
     * 
     * @author chencheng
     * @param ValidFreeAdvertOrderDto
     * @return
     * @since JDK 1.8
     */
    Integer updateValidFreeAdvertOrder(ValidFreeAdvertOrderDto validFreeAdvertOrderDto);

    /**
     * 
     * batchUpdateValidFreeAdvertOrder:(批量更新免费广告排序). <br/>
     * 
     * @author chencheng
     * @param ValidFreeAdvertOrderDto
     * @return
     * @since JDK 1.8
     */
    Integer batchUpdateValidFreeAdvertOrder(List<ValidFreeAdvertOrderDto> list);
    
    /**
     * 
     * insertValidFreeAdvert:(插入免费广告、免费代理商). <br/>
     *
     * @author chencheng
     * @param ValidFreeAdvertOrderDto
     * @return
     * @since JDK 1.8
     */
    Integer insertValidFreeAdvert(ValidFreeAdvertOrderDto validFreeAdvertOrderDto);
}

