package cn.com.duiba.tuia.core.api.remoteservice.abtest;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.ResultDto;
import cn.com.duiba.tuia.core.api.dto.abtest.MaterialBindABTestDTO;

import java.util.List;

/**
 * 素材绑定落地页测试Remote接口
 *
 * @author zhangbaiqiang
 * @date 2021/3/22
 */
@AdvancedFeignClient
public interface RemoteMaterialBindABTestService {

    /**
     * 素材绑定落地页测试按钮是否置灰
     *
     * @param advertId 广告Id
     * @return 是否置灰
     */
    ResultDto<Boolean> isDisable(Long advertId);

    /**
     * 创建测试计划
     *
     * @param req 请求参数
     * @return 是否创建成功
     */
    boolean create(MaterialBindABTestDTO req) throws BizException;

    /**
     * 停止测试计划
     *
     * @param id 测试计划Id
     * @return 是否创建成功
     */
    boolean stop(Long id) throws BizException;

    /**
     * 创建测试计划
     *
     * @param id 测试计划Id
     * @return 测试计划配置
     */
    MaterialBindABTestDTO detail(Long id);

    /**
     * 查询该广告的所有测试计划
     *
     * @param advertId 广告Id
     * @return 测试计划列表
     */
    List<MaterialBindABTestDTO> queryByAdvertId(Long advertId);

    /**
     * 查询测试流量占比
     *
     * @param advertId 广告Id
     * @return 测试流量占比
     */
    Integer queryTestFlowRatio(Long advertId);
}
