package cn.com.duiba.tuia.core.api.remoteservice.statistics;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.statistics.AdvertDownloadExposureDayDto;

import java.util.Date;
import java.util.List;

/**
 * @Description
 * @Author chensong
 * @Create 2018-11-08
 */
@AdvancedFeignClient
public interface RemoteAdvertDownloadExposureDayService {


    /**
     * 根据日期和广告主ID查询落地页曝光数据
     * @param accountId 广告主ID
     * @param curDate   选择时间
     * @return  广告落地页曝光数据
     */
    public List<AdvertDownloadExposureDayDto> selectByDateAndAccountId(Long accountId, Date curDate);

    /**
     * 根据摘要批量查询
     * @param dataSignList
     * @return
     */
    List<AdvertDownloadExposureDayDto> selectByDataSign(List<String> dataSignList);






}
