package cn.com.duiba.tuia.core.api.dto.advert;

import java.io.Serializable;
import java.util.List;

/**
 * 广告配置托管dto
 *
 * @author peanut.huang
 * @date 2019/4/26
 * @since JDK 1.8
 */
public class AdvertOrientTrusteeshipDto implements Serializable{

    private static final long serialVersionUID = -1928064009993252812L;

    /**
     * 广告计划id
     */
    private Long advertId;

    /**
     * 广告配置id
     */
    private Long orientId;

    /**
     * 计费方式：1-CPC, 2-OCPC
     */
    private Integer chargeType;

    /**
     * 投放目标类型，1-消耗优先、2-成本优先、3-均衡投放、4-人工定向、0-CPC的
     *
     * 0：属于人工包， 1-4：属于系统托管
     */
    private Integer putTargetType;

    /**
     * 配置目标转化出价
     */
    private Integer aFee;

    /**
     * ocpc调整因子
     */
    private Integer subtype;

    /**
     * 是否是默认配置，0 非默认，1默认
     */
    private Integer defaultOrient;

    /**
     * 配置的重点媒体转化出价列表
     */
    private List<OrientationFocusAppConvertCostDto> convertCostList;

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Long getOrientId() {
        return orientId;
    }

    public void setOrientId(Long orientId) {
        this.orientId = orientId;
    }

    public Integer getPutTargetType() {
        return putTargetType;
    }

    public void setPutTargetType(Integer putTargetType) {
        this.putTargetType = putTargetType;
    }

    public Integer getaFee() {
        return aFee;
    }

    public void setaFee(Integer aFee) {
        this.aFee = aFee;
    }

    public List<OrientationFocusAppConvertCostDto> getConvertCostList() {
        return convertCostList;
    }

    public void setConvertCostList(List<OrientationFocusAppConvertCostDto> convertCostList) {
        this.convertCostList = convertCostList;
    }

    public Integer getChargeType() {
        return chargeType;
    }

    public void setChargeType(Integer chargeType) {
        this.chargeType = chargeType;
    }

    public Integer getSubtype() {
        return subtype;
    }

    public void setSubtype(Integer subtype) {
        this.subtype = subtype;
    }

    public Integer getDefaultOrient() {
        return defaultOrient;
    }

    public void setDefaultOrient(Integer defaultOrient) {
        this.defaultOrient = defaultOrient;
    }
}
