/**
 * Project Name:tuia-advert-center-api File Name:ReqLoadingPageAppEffectDto.java Package
 * Name:cn.com.duiba.tuia.core.api.dto.req.data Date:2017年8月26日下午3:23:31 Copyright (c) 2017, duiba.com.cn All Rights
 * Reserved.
 */

package cn.com.duiba.tuia.core.api.dto.req.data;

import org.apache.commons.lang.builder.ToStringBuilder;

import cn.com.duiba.tuia.core.api.dto.BaseQueryDateReq;

/**
 * ClassName:ReqLoadingPageAppEffectDto <br/>
 * Function: 广告数据每小时实时数据查询. <br/>
 * Date: 2017年8月26日 下午3:23:31 <br/>
 * 
 * @author chencheng
 * @version
 * @since JDK 1.8
 * @see
 */
public class ReqAdvertStatisticsHourRealTimeDto extends BaseQueryDateReq {

    private static final long serialVersionUID = -2975511335911701618L;

    /** 广告ID. */
    private Long              advertId;

    /** 0 or null ：汇总，1：分日 */
    private Integer           exportType;

    /** 活动类型：0-互动广告，1-展示广告 */
    private Integer           activityType;

    /**
     * activityType.
     *
     * @return the activityType
     * @since JDK 1.8
     */
    public Integer getActivityType() {
        return activityType;
    }

    /**
     * activityType.
     *
     * @param activityType the activityType to set
     * @since JDK 1.8
     */
    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    /**
     * advertId.
     *
     * @return the advertId
     * @since JDK 1.8
     */
    public Long getAdvertId() {
        return advertId;
    }

    /**
     * advertId.
     *
     * @param advertId the advertId to set
     * @since JDK 1.8
     */
    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    /**
     * exportType.
     *
     * @return the exportType
     * @since JDK 1.8
     */
    public Integer getExportType() {
        return exportType;
    }

    /**
     * exportType.
     *
     * @param exportType the exportType to set
     * @since JDK 1.8
     */
    public void setExportType(Integer exportType) {
        this.exportType = exportType;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
