package cn.com.duiba.tuia.core.api.remoteservice.advert;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.advert.CouponUpldRecordDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by huangch on 2017/8/30 11:50
 * description:
 *
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteCouponUpldRecordService {

    /**
     * 新增优惠码上传记录.<br>
     * 【必传字段】
     * <ol>
     * <li>file_name:上传的优惠码文件名称</li>
     * <li>file_url:上传的优惠码文件URL</li>
     * </ol>
     * 【使用说明】
     * <ol>
     * <li>status:会初始化为-1(未绑定广告ID)</li>
     * <li>advertId:为null，需要等广告创建成功后，把广告ID写入到上传记录中</li>
     * </ol>
     *
     * @return 返回插入数据行生成的主键id
     */
    DubboResult<Integer> insert(CouponUpldRecordDto record);

    /**
     * 通过上传记录ID(主键)查询上传记录信息.<br>
     * 【返回字段】
     * <ol>
     * <li>id:优惠码文件上传记录ID</li>
     * <li>advert_id:优惠码文件所属的广告ID</li>
     * <li>file_name:上传的优惠码文件名称</li>
     * <li>file_url:上传的优惠码文件URL</li>
     * <li>status:上传的优惠码文件状态</li>
     * </ol>
     *
     * @param id 上传记录ID(主键)
     * @return 上传记录信息
     */
    DubboResult<CouponUpldRecordDto> selectByPrimaryKey(Long id);

    /**
     * 更新上传记录状态和劵码批次ID.
     *
     * @param id       记录ID
     * @param status   状态
     * @param batchId  批次ID
     * @param advertId 广告ID
     * @return the int
     */
    DubboResult<Integer> updateStatus(Long id, Integer status, Long batchId, Long advertId);

    /**
     * 根据批次D获取最后一个可用的优惠券文件.
     *
     * @param batchId the batch id
     * @return 上传记录信息
     */
    DubboResult<CouponUpldRecordDto> selectByBatchId(Long batchId);

    /**
     * 查询同一广告下相同优惠码文件名称的个数.<br>
     *
     * @param name     优惠码文件名称
     * @param advertId 广告ID
     * @return 最新上传的优惠码文件上传记录
     */
    DubboResult<Integer> getAmountByNameAndAdvertId(String name, Long advertId);
}
