package cn.com.duiba.tuia.core.api.remoteservice.statistics;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.statistics.MaterialDiagnosticMergeOutDto;
import cn.com.duiba.tuia.core.api.dto.statistics.MaterialDiagnosticMergeOutHlDto;

import java.util.List;

/**
 * Created by huangch on 2017/12/07 15:30
 * description:
 *
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteMaterialDiagnosticService {

    /**
     * 查询素材诊断数据
     *
     * @param materialIds 素材IDS
     * @param curDate     查询的诊断日期
     */
    List<MaterialDiagnosticMergeOutDto> selectByMaterialIdsAndCurDate(List<Long> materialIds, String curDate);

    /**
     * 查询素材诊断数据
     *
     * @param materialIds 素材IDS
     * @param curDate     查询的诊断日期
     */
    List<MaterialDiagnosticMergeOutHlDto> selectMaterialDiagnosticByMaterialIdsAndCurDate(List<Long> materialIds, String curDate);
}
