/**
 * Project Name:manager-domain File Name:GetAppDataReq.java Package Name:cn.com.duiba.tuia.manager.req
 * Date:2016年5月25日下午4:48:23 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.core.api.statistics.domain;

import org.apache.commons.lang.builder.ToStringBuilder;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * ClassName:GetAppDataReq <br/>
 * Function: 查询应用统计数据请求参数 <br/>
 * Date: 2016年5月25日 下午4:48:23 <br/>
 * .
 *
 * @author Administrator
 * @version
 * @since JDK 1.6
 * @see
 */
@ApiModel("查询应用统计数据请求参数")
public class GetAppDataReq extends ByDateQueryReq {

    private static final long serialVersionUID = 7305912222108270033L;

    /** app 来源 全部 */
    public static final int APP_SOURCE_ALL   = 0;
    
    /** app 来源 兑吧 */
    public static final int APP_SOURCE_DUIBA = 1;
    
    /** app 来源 推啊 */
    public static final int APP_SOURCE_TUIA  = 2;
    
    /** 应用ID. */
    @ApiModelProperty("应用ID")
    private Long       appId;

    /** 应用名称. */
    @ApiModelProperty("应用名称")
    private String     appName;

    @ApiModelProperty("标签ID")
    private Long tagId;

    @ApiModelProperty("模块ID")
    private Integer blockId;

    /** 广告ID. */
    @ApiModelProperty("广告ID")
    private Long       advertId;

    /** 广告名称. */
    @ApiModelProperty("广告名称")
    private String     advertName;

    /** app类型：0-全部 1-兑吧 2-推啊 */
    @ApiModelProperty("app类型：0-全部 1-兑吧 2-推啊")
    private Integer    appSource;
    
    /** 媒体ID集合(用于媒体名称模糊查询). */
    @ApiModelProperty(value = "媒体ID集合", hidden = true)
    private List<Long> appIds;

    /** 数据类型 :null-全部; 1-付费券; 2-免费券 */
    @ApiModelProperty("数据类型 :null-全部; 1-付费券; 2-免费券")
    private Integer dataType;
    
    /** 免费券广告主ID */
    @ApiModelProperty(value = "免费券广告主ID", hidden = true)
    private List<Long> freeAdvertiserIds;

    @ApiModelProperty("1-杭州推啊、2-霍尔果斯推啊，0-总的")
    private Integer            effectiveMainType;

    @ApiModelProperty("活动类型：0-互动广告，1-展示广告")
    private Integer           activityType;

    /**
     * activityType.
     *
     * @return the activityType
     * @since JDK 1.8
     */
    public Integer getActivityType() {
        return activityType;
    }

    /**
     * activityType.
     *
     * @param activityType the activityType to set
     * @since JDK 1.8
     */
    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    public Integer getEffectiveMainType() {
        return effectiveMainType;
    }

    public void setEffectiveMainType(Integer effectiveMainType) {
        this.effectiveMainType = effectiveMainType;
    }

    /**
     * advertName.
     *
     * @return the advertName
     * @since JDK 1.7
     */
    public String getAdvertName() {
        return advertName;
    }

    /**
     * advertName.
     *
     * @param advertName the advertName to set
     * @since JDK 1.7
     */
    public void setAdvertName(String advertName) {
        this.advertName = advertName;
    }

    /**
     * appId.
     *
     * @return the appId
     * @since JDK 1.7
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * appId.
     *
     * @param appId the app id
     * @since JDK 1.7
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * appName.
     *
     * @return the appName
     * @since JDK 1.7
     */
    public String getAppName() {
        return appName;
    }

    /**
     * appName.
     *
     * @param appName the app name
     * @since JDK 1.7
     */
    public void setAppName(String appName) {
        this.appName = appName;
    }

    /**
     * advertId.
     *
     * @return the advertId
     * @since JDK 1.7
     */
    public Long getAdvertId() {
        return advertId;
    }

    /**
     * advertId.
     *
     * @param advertId the advert id
     * @since JDK 1.7
     */
    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    /**
     * Gets the app ids.
     *
     * @return the app ids
     */
    public List<Long> getAppIds() {
        return appIds;
    }

    /**
     * Sets the app ids.
     *
     * @param appIds the app ids
     */
    public void setAppIds(List<Long> appIds) {
        this.appIds = appIds;
    }
    
    /**
     * appSource.
     *
     * @return  the appSource
     * @since   JDK 1.6
     */
    public Integer getAppSource() {
        return appSource;
    }
    
    /**
     * appSource.
     *
     * @param   appSource    the appSource to set
     * @since   JDK 1.6
     */
    public void setAppSource(Integer appSource) {
        this.appSource = appSource;
    }
	
	public Integer getDataType() {
		return dataType;
	}

	public void setDataType(Integer dataType) {
		this.dataType = dataType;
	}

	public List<Long> getFreeAdvertiserIds() {
		return freeAdvertiserIds;
	}

	public void setFreeAdvertiserIds(List<Long> freeAdvertiserIds) {
		this.freeAdvertiserIds = freeAdvertiserIds;
	}

    public Long getTagId() {
        return tagId;
    }

    public void setTagId(Long tagId) {
        this.tagId = tagId;
    }

    public Integer getBlockId() {
        return blockId;
    }

    public void setBlockId(Integer blockId) {
        this.blockId = blockId;
    }

    /**
     * To string.
     *
     * @return the string
     * @see Object#toString()
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
    
}
