package cn.com.duiba.tuia.core.api.utils;

import org.springframework.stereotype.Service;
import sun.net.util.IPAddressUtil;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;

/**
 * Created by huangch on 2017/10/17 11:44 description:
 *
 * @since JDK 1.6
 */
@Service
public class IpTool {

    /**
     * 判断是否为内网IP
     *
     * @param ip
     * @return
     */
    public static boolean internalIp(String ip) {
        byte[] addr = IPAddressUtil.textToNumericFormatV4(ip);
        return internalIp(addr);
    }

    private static boolean internalIp(byte[] addr) {
        final byte b0 = addr[0];
        final byte b1 = addr[1];
        // 10.x.x.x/8
        final byte section1 = 0x0A;
        // 172.16.x.x/12
        final byte section2 = (byte) 0xAC;
        final byte section3 = (byte) 0x10;
        final byte section4 = (byte) 0x1F;
        // 192.168.x.x/16
        final byte section5 = (byte) 0xC0;
        final byte section6 = (byte) 0xA8;

        // 10.x.x.x/8 ip段判断
        if (b0 == section1) {
            return true;
        }
        // 172.16.x.x/12 ip段判断
        if (b0 == section2 && b1 >= section3 && b1 <= section4) {
            return true;
        }
        // 192.168.x.x/16 ip段判断
        if (b0 == section5 && b1 == section6) {
            return true;
        }
        return false;
    }
}
