package cn.com.duiba.tuia.core.api.constant;

import com.google.common.collect.Lists;

import java.util.List;

/**
 * Created by huangch on 2017/11/1 16:32
 * description: 广告定向配置包常量集合
 *
 * @since JDK 1.6
 */
public class AdOrientPkgConstant {

    private AdOrientPkgConstant(){}

    //开启智能策略
    public static final int SMART_STRATEGY_OPEN = 1;
    //暂停智能策略
    public static final int SMART_STRATEGY_PAUSE = 0;
    //智能策略类型
    public static final int STRATEGY_TYPE_SMART = 2;
    //人工策略类型
    public static final int STRATEGY_TYPE_ARTIFICIAL = 1;
    //数据依据-广告
    public static final int DATA_SOURCE_ADVERT = 1;
    //数据依据-行业
    public static final int DATA_SOURCE_TRADE = 2;
    //出价依据-目标成本
    public static final int BID_OF_TARGET_COST = 1;
    //出价依据-统一CPC
    public static final int BID_OF_CPC = 2;

    //操作系统集合
    public static final List<String> PLATFORMS = Lists.newArrayList("Android", "IOS", "其他");
}
