package cn.com.duiba.tuia.core.api.dto.compensate;

import cn.com.duiba.tuia.core.api.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * 广告新赔付DTO
 *
 * @author zhangbaiqiang
 * @date 2021/1/5
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class CompensateNewAdvertDTO extends BaseDto implements Serializable {
    private static final long serialVersionUID = -9123216165075985808L;

    /**
     * 赔付日期
     */
    private Date compensateDate;

    /**
     * 计划id
     */
    private Long advertId;

    /**
     * 转化数
     */
    private Integer transferPv;

    /**
     * 赔付金额
     */
    private Integer compensateAmount;

    /**
     * 是否新计划（0.老计划；1.新计划）
     */
    private Integer isNew;

    /**
     * 返货赔付使用状态：0.不可用,1.可用
     */
    private Integer cashBackState;

    /**
     * 自动赔付使用状态：0.无效,1.自动赔付,2.线下赔付
     */
    private Integer autoCompensateState;

    /**
     * 提现申请状态：0.不可见,1.待申请,2.已申请
     */
    private Integer withdrawApplyState;

    /**
     * 自动赔付入账状态：0.无效,1.待入账,2.已入账
     */
    private Integer entryState;

    /**
     * 赔付返货入账时间
     */
    private Date entryTime;

    /**
     * 平台整体当日赔付金额是否超阈值：0.否,1.是
     */
    private Integer totalExceed;

    /**
     * 单计划当日赔付金额是否超阈值：0.否,1.是
     */
    private Integer advertExceed;
}
