package cn.com.duiba.tuia.core.api.remoteservice.land;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.land.LandPageDiagnosisDataDto;
import cn.com.duiba.tuia.core.api.dto.land.LandPageDiagnosisDto;
import cn.com.duiba.tuia.core.api.dto.land.LandPageDiagnosisResultDto;

import java.util.List;

/**
 * @author Wangpf
 * @description
 * @date 2019/7/22 17:15
 */
@AdvancedFeignClient
public interface RemoteLandPageDiagnosisService {

    /**
     * @param landPageDiagnosisDto 实体类
     * @return 影响行数
     */
    int insert(LandPageDiagnosisDto landPageDiagnosisDto);


    /**
     * 查询当前页面诊断数据
     *
     * @param pageId 页面Id
     * @return 当前页面诊断数据集
     */
    List<LandPageDiagnosisDataDto> findDiagnosisDataByPageId(long pageId);

    /**
     * @param diagnosisId 诊断结果ID
     * @return 当前诊断结果
     */
    LandPageDiagnosisDataDto  findDiagnosisDataById(long diagnosisId);
}
