package cn.com.duiba.tuia.core.api.remoteservice.urgent;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.req.urgent.UrgentRecordOrientPkgReq;
import cn.com.duiba.tuia.core.api.dto.rsp.urgent.UrgentRecordAdvertOrientPkgDto;

/**
 * 
 * ClassName: RemoteUrgentRecordOrientPkgService <br/>
 * Function: 应急广告填充广告配置详细记录. <br/>
 * date: 2019年5月17日 上午11:10:20 <br/>
 *
 * @author chencheng
 * @version 
 * @since JDK 1.8
 */
@AdvancedFeignClient
public interface RemoteUrgentRecordOrientPkgService {

    /**
     * 
     * selectUrgentRecordDetail:(查询应急广告填充广告配置详细记录). <br/>
     *
     * @author chencheng
     * @param req
     * @return
     * @since JDK 1.8
     */
    List<UrgentRecordAdvertOrientPkgDto> selectUrgentRecordDetail(UrgentRecordOrientPkgReq req);

    /**
     * 总数
     * @param entity
     * @return
     */
    Integer countUrgentRecordDetail (UrgentRecordOrientPkgReq entity);

    /**
     * 
     * batchInsert:(批量插入). <br/>
     *
     * @author chencheng
     * @param list
     * @return
     * @since JDK 1.8
     */
    int batchInsert(List<UrgentRecordAdvertOrientPkgDto> list);

    /**
     * 广告填充后发的钉钉消息
     * @param advertIds
     * @return
     */
    void sendDingNotice(List<Long> advertIds);
}

