package cn.com.duiba.tuia.core.api.param;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

/**
 * Created by zhangshun on 2019/6/26.
 */
public class AdvertSupportPlanParam implements Serializable {

    private static final long serialVersionUID = 7417325376189417895L;

    /** 广告名称 */
    private String advertName;

    /** 广告IDs */
    private Long advertId;

    /** 广告IDs */
    private List<Long> advertIds;

    /** 广告主名称 */
    private String accountName;

    /** 广告主ID */
    private Long accountId;

    /** 广告主ID */
    private List<Long> accountIds;

    /** 资源ID */
    private String tagName;

    /** 扶持状态，1=扶持中、2=已暂停、3=已结束 */
    private Integer planState;

    private Integer currentPage=1;

    private Integer pageSize=20;

    public String getAdvertName() {
        return advertName;
    }

    public void setAdvertName(String advertName) {
        this.advertName = advertName;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public List<Long> getAdvertIds() {
        return advertIds;
    }

    public void setAdvertIds(List<Long> advertIds) {
        this.advertIds = advertIds;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public List<Long> getAccountIds() {
        return accountIds;
    }

    public void setAccountIds(List<Long> accountIds) {
        this.accountIds = accountIds;
    }

    public String getTagName() {
        return tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public Integer getPlanState() {
        return planState;
    }

    public void setPlanState(Integer planState) {
        this.planState = planState;
    }

    public Integer getCurrentPage() {
        return currentPage;
    }

    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getOffset() {
        if(Objects.nonNull(currentPage) && Objects.nonNull(pageSize)){
            return (currentPage-1)*pageSize;
        }
        return 0;
    }
}
