package cn.com.duiba.tuia.core.api.param;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;

import cn.com.duiba.tuia.core.api.statistics.domain.BaseQueryReq;

/**
 * 广告计划赔付分页查询参数
 *
 * @author peanut.huang
 * @date 2019/10/15
 * @since JDK 1.8
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ToString
public class CompensatePagingParam extends BaseQueryReq implements Serializable{

    private static final long serialVersionUID = 7417325376189417895L;


    /**
     * 要赔付的日期起始
     */
    private String          startDate;

    /**
     * 要赔付的日期结束
     */
    private String          endDate;

    /**
     * 计划id
     */
    private Long            advertId;


    /**
     * 赔付状态 {@link cn.com.duiba.tuia.core.api.enums.compensate.CompensateStatusEnum#status}
     */
    private Integer         compensateStatus;

    /**
     * 赔付开关 {@link cn.com.duiba.tuia.core.api.enums.compensate.CompensateSwitchEnum#status}
     */
    private Integer         compensateSwitch;

    /**
     * 返货赔付使用状态：0.不可用,1.可用
     */
    private Integer cashBackState;

    /**
     * 自动赔付使用状态：0.无效,1.自动赔付,2.线下赔付
     */
    private Integer autoCompensateState;

    /**
     * 提现申请状态：0.不可见,1.待申请,2.已申请
     */
    private Integer withdrawApplyState;

    /**
     * 自动赔付入账状态：0.无效,1.待入账,2.已入账
     */
    private Integer entryState;

    /**
     * 平台整体当日赔付金额是否超阈值：0.否,1.是
     */
    private Integer totalExceed;

    /**
     * 单计划当日赔付金额是否超阈值：0.否,1.是
     */
    private Integer advertExceed;
}
