/**
 * Project Name:tuia-core-api<br>
 * File Name:RemoteAdvertTagBackendService.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.remoteservice<br>
 * Date:2016年10月26日上午9:47:49<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.core.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.AdvertTagDto;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;

/**
 * ClassName: RemoteAdvertTagBackendService <br/>
 * Function: 广告标签. <br/>
 * date: 2016年10月26日 上午9:47:49 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteAdvertTagBackendService {

    /**
     * 更新广告标签.
     *
     * @param advertId the advert id
     * @param matchTagNums the match tag nums
     * @param bannedTagNums the banned tag nums
     * @return the dubbo result< boolean>
     */
    @RequestMapping("/updateAdvertTags1")
    DubboResult<Boolean> updateAdvertTags(long advertId, String matchTagNums, String advertBannedTagNums);
    
    /**
     * 更新广告标签、定向配置标签.
     *
     * @param advertId the advert id
     * @param matchTagNums 特征标签
     * @param advertBannedTagNums 屏蔽标签
     * @param bannedTagNums 默认配置标签
     * @return the dubbo result< boolean>
     */
    @RequestMapping("/updateAdvertTags2")
    DubboResult<Boolean> updateAdvertTags(long advertId, String matchTagNums, String advertBannedTagNums, String bannedTagNums);

    /**
     * 根据广告ID查询广告标签.
     *
     * @param advertId the advert id
     * @return the dubbo result< advert tag dto>
     */
    DubboResult<AdvertTagDto> selectAdvertTag(long advertId);
    
    /**
     * 更新广告默认定向配置屏蔽标签
     * @param advertId
     * @param bannedTagNums
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> updateBannedTag(Long advertId, String bannedTagNums);

    /**
     * 通过广告id查询广告特征标签列表
     *
     * @param advertIds
     * @return
     */
    DubboResult<List<AdvertTagDto>> listAdvertMatchTagNumsByAdvertIds(List<Long> advertIds);

    /**
     * 通过广告id查询广告标签列表
     * @param advertIds
     * @return
     */
    DubboResult<List<AdvertTagDto>> listAdvertTagByAdvertIds(List<Long> advertIds);
    
    /**
     * 
     * listAllValidAdvertTagNums:(获取所有广告标签). <br/>
     *
     * @author chencheng
     * @param validStatus 广告有效状态：1有效。空表示所有
     * @return
     * @since JDK 1.8
     */
    List<AdvertTagDto> listAllValidAdvertTagNums(Integer validStatus);
    
    /**
     * 
     * batchUpdateAdvertTags:(批量更新广告标签). <br/>
     *
     * @author chencheng
     * @param list
     * @return
     * @since JDK 1.8
     */
    Integer batchUpdateAdvertTags (List<AdvertTagDto> list);
    
    /**
     * 
     * batchUpdateAdvertTags:(批量更新广告标签). <br/>
     *
     * @author chencheng
     * @param list
     * @return
     * @since JDK 1.8
     */
    Integer batchAddAdvertTags (List<AdvertTagDto> list);


    /**
     *通过行业获取对于广告
     * @param matchTag
     * @return
     */
    List<Long> getAdvertIdsByMatchTag(String matchTag);
}
