/**
 * 文件名： CreateAdverReq.java 此类描述的是： 作者: leiliang 创建时间: 2016年4月5日 下午2:38:27
 */
package cn.com.duiba.tuia.core.api.dto;

import cn.com.duiba.tuia.core.api.dto.advert.AdvertExpandDto;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 广告表.
 *
 * @author: leiliang
 * @version:
 */
@Getter
@Setter
@ToString
public class AdvertDto extends BaseDto {

    private static final long   serialVersionUID                 = -4140124221247023188L;

    /** 所有投放平台. */
    public static final int ALL_PALTFORM                     = 0;

    /** ios投放平台. */
    public static final int IOS_PALTFORM                     = 2;

    /** Android投放平台. */
    public static final int ANDROID_PALTFORM                 = 1;

    /** cpc计费方式. */
    public static final int CPC_CHARGE_TYPE                  = 1;

    /** 启用状态. */
    public static final int ENABLE                           = 1;

    /** 暂停状态. */
    public static final int SUSPEND                          = 0;

    /** 审核中. */
    public static final int CHECK_STATUS_ING                 = 0;

    /** 审核通过. */
    public static final int CHECK_STATUS_PASS                = 1;

    /** 审核拒绝. */
    public static final int CHECK_STATUS_REFUSE              = 2;

    /** 有效状态. */
    public static final int VALID_STATUS                     = 1;

    /** 无效(暂停)状态. */
    public static final int INVALID_SUSPEND                  = 2;

    /** 无效(审核中)状态. */
    public static final int INVALID_CHECK_IN                 = 3;

    /** 无效(审核拒绝)状态. */
    public static final int INVALID_CHECK_REFUSE             = 4;

    /** 无效(账号余额不足)状态. */
    public static final int INVALID_BALANCE_NOT_ENOUGH       = 5;

    /** 无效(账号预算不足)状态. */
    public static final int INVALID_BALANCE_BUDGET_SHORTFALL = 6;

    /** 无效(广告预算不足)状态. */
    public static final int INVALID_ADVERT_BUDGET_SHORTFALL  = 7;

    /** 无效(库存不足)状态. */
    public static final int INVALID_INADEQUATE_INVENTORY     = 8;

    /** 无效(非投放日期)状态. */
    public static final int INVALID_NON_DELIVERY_DATE        = 9;

    /** 无效(优惠码失效)状态. */
    public static final int INVALID                          = 10;

    /** 无效(落地页审核被拒绝)状态. */
    public static final int INVALID_LAND_PAGE_CHECK_REFUSE   = 11;

    /** 无效(兑吧广告)状态. */
    public static final int INVALID_DUIBA                    = 0;

    /** 广告来源：广告平台. */
    public static final int     TUIA_ADVERT_SOURCE               = 0;

    /** 广告来源：兑吧商品. */
    public static final int     DUIBA_GOODS_SOURCE               = 1;

    /** 广告来源：兑吧券库. */
    public static final int     DUIBA_COUPON_SOURCE              = 2;

    /** 广告未删除. */
    public static final int     ISDELETED_NOT_DELETED            = 0;

    /** 广告失效状态标识，0-未失效. */
    public static final int     ABATE_VALID            = 0;

    /** 广告ID. */
    private Long advertId;

    //广告类型
    private Integer advertType;

    //广告推广链接
    private String promoteUrl;

    /**
     * 广告主获取用户信息回传链接
     */
    private String promoteBackUserUrl;

    /**
     * 曝光监测链接
     */
    private String promoteExposureMonitorUrl;

    /** 深度链接 */
    private String promoteDeepLink;

    /**
     * 新增的uLink链接
     */
    private String promoteULink;

    /** app 下载链接*/
    private String appDownloadUrl;

    // 推广链接类型 1：落地页网址，2：落地页名称
    private Integer                  promoteType;

    /** 广告主ID. */
    private Long                accountId;

    /** 名称. */
    private String              name;

    /** 每日预算. */
    private Long                budgetPerDay;

    /** 生效期. */
    private Date                startDate;

    /** 失效期. */
    private Date                endDate;

    /** 级别. */
    private Long                level;

    /** 级别更新时间(毫秒数). */
    private Long                levelUpdateTime;

    /** 启用状态. */
    private Integer             enableStatus;

    /** 审核状态. */
    private Integer             checkStatus;

    //拒绝原因
    private String refuseReason;

    /** 有效状态. */
    private Integer             validStatus;

    //同流量竞价类型，1-成本优先、2-优先抢量
    private Integer flowBiddingType;

    /** 是否被删除. */
    private Integer             isDeleted;

    /** 优惠码id. */
    private Long                duibaId;
    /** 广告来源 */
    private Integer             source;

    private Integer           abate;

    /** 是否开启重复曝光：0 否 1是 **/
    private Integer repeatExposure;

    /**广告主*/
    private String companyName;

    /**代理商*/
    private String agentCompanyName;

    /**
     * 广告权重
     */
    private BigDecimal advertWeight;

    //是否开启广告失效异常提醒状态,0-关闭，1-开启,默认开启
    private Integer invalidRemindStatus;

    //是否开启广告消耗异常提醒状态,0-关闭，1-开启,默认开启
    private Integer consumeAbnRemindStatus;

    /** 兑吧审核：0：未审，1：已审 */
    private Integer duibaAudit;

    /**是否ocpc有限 1-是 0-否*/
    private Integer ocpcFirst;

    /** 福利流量投放：0-否，1-是 **/
    private Integer welfareFlowType;

    /** 审核人 */
    private String auditor;

    /** 审核时间 */
    private Date auditTime;

    private Date editTime;

    /** 是否重定向：0-否,1-是 */
    public Integer redirectType;
    /** 广告静默下载状态:0 否 1 是*/
    public Integer downloadStatus;

    /** 进审时间. */
    private Date enterCheckTime;

    /** 关键词命中落地页标签*/
    public String wordHitTag;

    /** 考核指标类型 */
    private Integer assessType;

    /** 考核成本 */
    private Long assessCost;

    /** 推广计划Id*/
    private Long advertPlanId;

    /** 是否仅投放设备号流量 */
    private Integer advertOnlyPutDevice;

    /**
     * dp广告类型字段，1-》adx广告，2-》dp广告
     */
    private Integer dpAdvertType;

    /** 关键词命中素材标签*/
    public String materialWordHitTag;

    /** icp备案公司名称*/
    public String icpName;

    /** 二跳链接域名icp备案公司名称*/
    public String jumpIcpName;

    /** 广告扩展字段 */
    public AdvertExpandDto advertExpand;

    private String advertPlanName;

    /** 深度考核指标 */
    private Integer depthSubtype;

    /** 深度考核成本,单位:分 */
    private Integer depthTargetPrice;

    /**
     * deeplink类型  1单链接  2链接库
     */
    private Integer deepLinkType;
    /**
     * ulink 1单链接  2链接库
     */
    private Integer uLinkType;
    /**
     * ulink链接库id
     */
    private Long uLinkLibrary;
    /**
     * deeplink链接库id
     */
    private Long deepLinkLibrary;

    private Integer circuitBreakFlag;

    // 设置广告拓展表的字段
    public void setAdvertExpandInfo(AdvertExpandDto advertExpandDto){
        if (advertExpandDto == null) {
            return;
        }
        this.advertOnlyPutDevice = advertExpandDto.getAdvertOnlyPutDevice();
        this.advertExpand = advertExpandDto;
        this.depthSubtype = advertExpandDto.getDepthSubtype();
        this.depthTargetPrice = advertExpandDto.getDepthTargetPrice();
    }
}
