/**
 * Project Name:tuia-core-api<br>
 * File Name:AdvertMaterialCache.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.dto<br>
 * Date:2016年12月26日上午9:33:45<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.core.api.dto;

import java.io.Serializable;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName: AdvertMaterialCache <br/>
 * Function: 素材缓存. <br/>
 * date: 2016年12月26日 上午9:33:45 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class AdvertMaterialCache implements Serializable {

    /**
     * @since JDK 1.7
     */
    private static final long serialVersionUID = 3728841923845962581L;

    /** 素材ID. */
    protected Long id;

    /** 商品名称. */
    private String couponName;

    /** 详情页banner图. */
    private String bannerPng;

    /** 按钮文案. */
    private String buttonText;

    /** 一句话描述. */
    private String description;

    /**
     * Creates a new instance of AdvertMaterialCache.
     *
     * @param id the id
     * @param couponName the coupon name
     * @param bannerPng the banner png
     * @param buttonText the button text
     * @param description the description
     */

    public AdvertMaterialCache(Long id, String couponName, String bannerPng, String buttonText,
                               String description) {
        super();
        this.id = id;
        this.couponName = couponName;
        this.bannerPng = bannerPng;
        this.buttonText = buttonText;
        this.description = description;
    }

    /**
     * Creates a new instance of AdvertMaterialCache.
     */

    public AdvertMaterialCache() {
        super();
    }

    /**
     * Gets the id.
     *
     * @return the id
     */
    public Long getId() {
        return id;
    }

    /**
     * Sets the id.
     *
     * @param id the id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * Gets the coupon name.
     *
     * @return the coupon name
     */
    public String getCouponName() {
        return couponName;
    }

    /**
     * Sets the coupon name.
     *
     * @param couponName the coupon name
     */
    public void setCouponName(String couponName) {
        this.couponName = couponName;
    }

    /**
     * Gets the banner png.
     *
     * @return the banner png
     */
    public String getBannerPng() {
        return bannerPng;
    }

    /**
     * Sets the banner png.
     *
     * @param bannerPng the banner png
     */
    public void setBannerPng(String bannerPng) {
        this.bannerPng = bannerPng;
    }

    /**
     * Gets the button text.
     *
     * @return the button text
     */
    public String getButtonText() {
        return buttonText;
    }

    /**
     * Sets the button text.
     *
     * @param buttonText the button text
     */
    public void setButtonText(String buttonText) {
        this.buttonText = buttonText;
    }

    /**
     * Gets the description.
     *
     * @return the description
     */
    public String getDescription() {
        return description;
    }

    /**
     * Sets the description.
     *
     * @param description the description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
