package cn.com.duiba.tuia.core.api.dto.coupon;

import lombok.Data;

import java.io.Serializable;

@Data
public class AdvertNewCouponGoodsDto implements Serializable {


    private static final long serialVersionUID = -663423163434562284L;
    //主键id
    private Long id;

    /** 优惠卷id. */
    private long              advertId;

    /** 推广网址. */
    private String            promoteURL;

    /** 商品名称. */
    private String            couponName;

    /** 商品价值(单位为分). */
    private Long              couponPrice;

    /** 兑换成功文案. */
    private String            exchangeTips;

    /** 品牌图标. */
    private String            thumbnailPng;

    /** 首页banner图. */
    private String            bannerPng;

    /** 领取次数限制. */
    private Integer           limitReceive;

    /** 优惠码类型. */
    private Integer           couponType;

    /** 是否隐藏. 对特殊应用隐藏使用按钮(0：否，1：是) */
    private boolean           displayMenu;

    /** 是否为微信券. 是否为微信券(0：否，1：是) (只有code_type=2 or code_type=3时有效) */
    private boolean           isWeixin;

    private String            buttonText;
}
