package cn.com.duiba.tuia.core.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.AdvertLinkRDto;
import cn.com.duiba.tuia.core.api.dto.LinkDto;
import cn.com.duiba.tuia.core.api.dto.LinkLibraryDto;
import cn.com.duiba.tuia.core.api.dto.LinkLibraryQuery;
import cn.com.duiba.tuia.core.api.dto.LinkQuery;
import cn.com.duiba.tuia.core.api.dto.PageDto;

import java.util.List;

/**
 * Created by hong
 * time 2024/7/22.
 */
@AdvancedFeignClient
public interface RemoteLinkService {
    Boolean batchInsertLink(List<LinkDto> linkDto);

    Boolean batchInsertLinkLibrary(List<LinkLibraryDto> dto);

    Boolean batchInsertAdvertLinkR(List<AdvertLinkRDto> dto);

    Boolean insertLink(LinkDto linkDto);

    Boolean insertLinkLibrary(LinkLibraryDto dto);

    Boolean insertAdvertLinkR(Long advertId, Long libraryId);

    Boolean deleteAdvertLinkR(Long advertId, Long libraryId);

    Boolean deleteLink(List<Long> linkIds);

    Boolean deleteLinkLibrary(List<Long> libraryIds);

    Boolean batchUpdateLink(LinkDto linkDto);

    Boolean batchUpdateLinkLibrary(LinkLibraryDto dto);

    Boolean batchUpdateAdvertLinkR(List<AdvertLinkRDto> dto);

    Boolean updateLink(String link, String libraryId);

    Boolean updateLinkLibrary(String libraryId, String name, String type, String activePlan, String remark);

    Boolean updateAdvertLinkR(String advertId, String libraryId);

    List<LinkLibraryDto> libraryAllList(Long createdId);

    PageDto<LinkLibraryDto> libraryList(LinkLibraryQuery dto);

    PageDto<LinkDto> linkList(LinkQuery dto);

    LinkDto sumLinkData(LinkQuery dto);

    LinkLibraryDto sumLibraryData(LinkLibraryQuery dto);

    LinkLibraryDto getLibrary(Long id);

    LinkDto getLink(Long id);
}
