package cn.com.duiba.tuia.core.api.remoteservice.account;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.account.rsp.AccountChangeTaskDto;


import javax.xml.crypto.Data;
import java.util.Date;
import java.util.List;

/**
 * @author fanjia
 * @date 2021年09月23日 下午4:59
 */
@AdvancedFeignClient
public interface RemoteAccountChangeTaskService {

    /**
     * 根据任务执行日期+状态来查询
     *
     * @param taskScheduledDate
     * @author fanjia
     * @date 2021/9/25 下午3:16
     */
    List<AccountChangeTaskDto> listByTaskScheduledDate(String taskScheduledDate);

    /**
     * 根据任务执行日期+状态来查询
     *
     * @param taskScheduledDate
     * @param state
     * @return java.util.List<cn.com.duiba.tuia.core.api.dto.account.rsp.AccountChangeTaskDto>
     * @author fanjia
     * @date 2021/9/25 下午3:16
     */
    List<AccountChangeTaskDto> listByTaskScheduledDateAndTaskState(String taskScheduledDate, Integer state);


    /**
     * 根据账户id集合查询 余额为0的的账户id集合列表
     *
     * @param accountIdList
     * @return java.util.List<java.lang.Long> 返回余额为0的的账户id集合列表
     * @author fanjia
     * @date 2021/9/23 下午5:44
     */
    List<Long> listMoneyZeroAccountIdList(List<Long> accountIdList);

    Integer update(AccountChangeTaskDto accountChangeTaskDto);

    /**
     * result=true 代表dmp数据回流成功 通知我们， false 代表数据回流异常。通知我们/
     * currentDate回流成功的时间时间搓
     *
     * @param result
     */
    Integer dmpDateSyncMessage(Boolean result, Long currentDate);

    /**
     * @param currentDate 日期 年月日
     * @return java.lang.Boolean
     * @author fanjia
     * @date 2021/9/26 上午9:56
     */
    Boolean selectDmpDateSyncByDate(String currentDate);


    /**
     * 广告主账户冻结与解冻.(代理商的账户冻结逻辑不是这个.)
     * 该接口是摘抄manager那边的冻结解冻的一部分逻辑 给自动迁户那边冻结解冻用,如果用这个接口 需要自己看看符合自己的需求吗
     *
     * @param accountId 广告主账户ID
     * @param status    冻结或解冻状态值 AccountDto.FREEZED_STATUS,AccountDto.UNFREEZED_STATUS
     * @param reason    the reason 冻结原因
     * @param reviewer  reviewer 冻结人名称
     * @return the int
     */
    Boolean updateFreezeStatus(Long accountId, Integer status, String reason, String reviewer);

    /**
     * 执行迁户逻辑数据修改等操作
     * @param accountId   广告主id
     * @param newAgentId  新的代理商id(广告主需要迁入的代理商id)
     * @param date 迁户时间
     * @return java.lang.Boolean
     * @author fanjia
     * @date 2021/9/26 上午10:22
     */
    Boolean accountChange(Long accountId, Long newAgentId,Date date);

    /**
     *  迁户相关的钉钉通知
     * @author fanjia
     * @date 2021/9/26 下午6:04
     * @param content
     */
    void sendDingDing(String content);



    /**
     * 分页查询
     */
    PageDto<AccountChangeTaskDto> pageList(AccountChangeTaskDto accountChangeTask);

    AccountChangeTaskDto getById(Long id);

}
