package cn.com.duiba.tuia.core.api.remoteservice.advert;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.AdvertDto;
import cn.com.duiba.tuia.core.api.dto.advert.AdvertPlanMaterialDto;
import cn.com.duiba.tuia.core.api.dto.advert.AdvertPopularizePlanDto;
import cn.com.duiba.tuia.core.api.dto.req.ReqGetAdvertIds;
import cn.com.duiba.tuia.core.api.dto.req.ReqGetCreateAdvertDto;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @Description: 推广计划相关 数据 服务类
 * @Param:
 * @return:
 * @Author: Micheal.Wang
 * @Date: 2019/10/8 0008
 */
@AdvancedFeignClient
public interface RemoteAdvertPopularizePlanService {


    /**
     * 根据名称 和 id 模糊查询 推广计划名称
     * @param advertPlanName
     * @param advertPlanId
     * @return
     */
    List<Long> selectAdvertPlanIdsLikeNameAndId(String advertPlanName,Long advertPlanId);



    List<Long> selectAdvertPlanIdsLikeName(String advertPlanName);
    /**
     * @Description: 根据广告主 获取 推广计划
     * @Param: [reqGetAdvertIds]
     * @return: java.util.List<cn.com.duiba.tuia.core.api.dto.AdvertDto>
     * @Author: Micheal.Wang
     * @Date: 2019/10/8 0008
     */
    List<AdvertDto> getAdvertIdsOfAdvertiser(ReqGetAdvertIds reqGetAdvertIds);


    /**
     * @Description: 推广计划名称获取关联的广告名称
     * @Param: [reqGetAdvertIds]
     * @return: java.util.List<cn.com.duiba.tuia.core.api.dto.AdvertDto>
     * @Author: Micheal.Wang
     * @Date: 2019/10/8 0008
     */
    List<AdvertDto> getAdvertLikeName(String name);

    /**
     * @Description: 根据推广计划id查询 关联的 广告id
     * @Param: [advertPlanId]
     * @return: java.util.List<java.lang.Long>
     * @Author: Micheal.Wang
     * @Date: 2019/10/10 0010
     */

    List<AdvertDto> selectAdvertByAdvertPlanId(Long advertPlanId);


    /**
     * @Description: 根据推广计划id查询 推广计划 合并成 广告
     * @Param: [advertPlanIds]
     * @return: java.util.Map<java.lang.Long, cn.com.duiba.tuia.core.api.dto.AdvertDto>
     * @Author: Micheal.Wang
     * @Date: 2019/10/10 0010
     */
    Map<Long, AdvertDto> selectAdvertMapByAdvertPlanIds(Set<Long> advertPlanIds);

    /**
     * @Description: 根据推广计划id查询 推广计划 合并成 广告
     * @Param: [advertPlanIds]
     * @return: java.util.Map<java.lang.Long, cn.com.duiba.tuia.core.api.dto.AdvertDto>
     */
    Map<Long, AdvertDto> selectAdvertByAdvertPlanIds(Set<Long> advertPlanIds);


    /**
     * @Description: 创建 推广计划
     * @Param: [createAdvertDto]
     * @return: java.lang.Long
     * @Author: Micheal.Wang
     * @Date: 2019/10/11 0011
     */
    Long createAdvertPlan(ReqGetCreateAdvertDto createAdvertDto) throws BizException;


    /**
     * @Description: 根据推广计划id查询互动广告id
     * @Param: [advertPlanId]
     * @return: java.lang.Long
     * @Author: Micheal.Wang
     * @Date: 2019/10/15 0015
     */
    Long seleHDAdvertIdByAdvertPlanId(Long advertPlanId);

    /**
     * @Description: 根据推广计划id查询推广计划
     * @Param: [advertPlanId]
     * @return: java.lang.Long
     * @Author: Micheal.Wang
     * @Date: 2019/10/15 0015
     */
    AdvertPopularizePlanDto seleAdvertPlanByAdvertPlanId(Long advertPlanId);

    /**
     * 根据推广计划id 和 广告主ids查询 推广计划
     *
     * @param advertPlanId
     * @param accountIds
     * @return
     */
    List<AdvertPopularizePlanDto> selectAdvertPopularizePlanDto(Long advertPlanId, String name ,List<Long> accountIds);

    /**
     * @Description: 根据推广计划ids 查询 关联的广告对象
     * @Param: [advetPlanIds]
     * @return: java.util.Map<java.lang.Long, java.util.List < cn.com.duiba.tuia.core.api.dto.AdvertDto>>
     * @Author: Micheal.Wang
     * @Date: 2019/10/16 0016
     */
    Map<Long, List<AdvertDto>> selectAdvertDtosByAdvertPlanIds(List<Long> advetPlanIds);

    /**
     * 修改推广计划的 预算
     * @param advertPlanId
     * @param budgetPerDay
     * @return
     */
    Integer updateAdverPlanBudgetPerDay(Long advertPlanId, Long budgetPerDay);


    /**
     * 根据 推广计划ids 查询推广计划属性
     * @param adpids
     * @return
     */
    List<AdvertPopularizePlanDto> selectAdvertPopularizePlanDtosAdvertPlanIds(List<Long> adpids);


    /***
    *@ClassName RemoteAdvertPopularizePlanService
    *@Description 根据推广计划id查询互动广告信息
    *@Author lijian
    *@Date 2020/8/4 14:39
    *@Version 1.0
    */
    List<AdvertDto> getHDAdvertIdByAdvertPlanId(List<Long> advertPlanIds);

    /**
     * 查询推广计划下的所有素材列表
     * @param advertPlanId
     * @return
     */
    List<AdvertPlanMaterialDto> selectAdvertPlanMaterialList(Long advertPlanId, Long advertId);

    /**
     * 查询推广计划下的所有落地页列表
     * @param advertPlanId
     * @return
     */
    Set<String> selectAdvertLandingPageList(Long advertPlanId, Long advertId);

    /**
     * 根据广告主列表查询
     * @param accountList
     * @return
     */
    List<AdvertDto> selectListByAccountList(List<Long> accountList);

    /**
     * 根据广告主ID和状态查询广告列表
     * @param accountIds
     * @param validStatus
     * @return
     */
    List<AdvertDto> selectByAccountIdsAndValidStatus(List<Long> accountIds, Integer validStatus);



}
