package cn.com.duiba.tuia.core.api.remoteservice.orientPkg;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.req.orientPkg.OrientPkgExpandReq;
import cn.com.duiba.tuia.core.api.dto.rsp.orientPkg.OrientPkgExpandDto;
import cn.com.duiba.tuia.core.api.enums.OrientPeoplePkgOrientTypeEnum;

import java.util.List;
import java.util.Set;

/**
 * 
 * ClassName: RemoteOrientPkgExpandService <br/>
 * Function: 定向配置拓展信息. <br/>
 * date: 2019年5月17日 下午3:54:52 <br/>
 *
 * @author chencheng
 * @version 
 * @since JDK 1.8
 */
@AdvancedFeignClient
public interface RemoteOrientPkgExpandService {

    /**
     * 
     * selectByOrientId:(根据配置id查询配置拓展信息). <br/>
     *
     * @author chencheng
     * @param orientId
     * @return
     * @since JDK 1.8
     */
    OrientPkgExpandDto selectByOrientId(Long orientId);
    
    /**
     * 
     * selectByEntity:(批量查询配置拓展新增). <br/>
     *
     * @author chencheng
     * @param query
     * @return
     * @since JDK 1.8
     */
    List<OrientPkgExpandDto> selectByEntity(OrientPkgExpandReq query);
    
    /**
     * 
     * addOrientPkgExpand:(新增配置拓展). <br/>
     *
     * @author chencheng
     * @param dto
     * @return
     * @since JDK 1.8
     */
    int addOrientPkgExpand(OrientPkgExpandDto dto);
    
    /**
     * 
     * updateOrientPkgExpand:(修改配置拓展). <br/>
     *
     * @author chencheng
     * @param dto
     * @return
     * @since JDK 1.8
     */
    int updateOrientPkgExpand(OrientPkgExpandDto dto);

    /**
     * 根据 obct 字段选择配置id（真实配置id）
     *
     * @param tag
     * @return
     */
    List<Long> selectByOBCTTag(String tag);

    /**
     * 插入 定向配置 obct 字段 值为 @tag
     *
     * @param addSet
     * @param tag
     * @return
     */
    Integer addOrientPkgExpandOBCT(Set<Long> addSet, String tag);

    /**
     * 更新 定向配置 obct 字段 值变更为 @tag
     *
     * @param updateSet
     * @param tag
     * @return
     */
    Integer updateOrientPkgExpandOBCT(Set<Long> updateSet, String tag);


    /**
     * 保存配置的定向人群包类型（定向、排除）
     * @return
     */
    Integer submitOrientPkgExpandOrientType(Long orientId, OrientPeoplePkgOrientTypeEnum orientPeoplePkgOrientTypeEnum);


    /**
     * 批量 保存配置的定向人群包类型（定向、排除）
     * @return
     */
    Integer submitOrientPkgsExpandOrientType(List<Long> orientId, OrientPeoplePkgOrientTypeEnum orientPeoplePkgOrientTypeEnum);


    /**
     * 查询定向配置的人群包定向类型
     * @param orientId
     * @return
     */
    OrientPeoplePkgOrientTypeEnum obtainOrientPeopleTypeByOrientPkgId(Long orientId);

}

