/**
 * Project Name:tuia-advert-center-api
 * File Name:RemoteQualificationAuditService.java
 * Package Name:cn.com.duiba.tuia.core.api.remoteservice.qualification
 * Date:2017年12月1日上午9:59:03
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.core.api.remoteservice.qualification;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.req.qualification.ReqQualificationQueryRecordDto;
import cn.com.duiba.tuia.core.api.dto.req.qualification.ReqeQualificationRecordDetailDto;
import cn.com.duiba.tuia.core.api.dto.rsp.account.QualificationQueryDetailDto;
import cn.com.duiba.tuia.core.api.dto.rsp.account.QualificationQueryRecordDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteQualificationQueryService {

    PageDto<QualificationQueryRecordDto> getList(ReqQualificationQueryRecordDto dto);

    List<QualificationQueryDetailDto> getDetail(String recordId, List<Long> ids);

    PageDto<QualificationQueryDetailDto> getDetailPage(ReqeQualificationRecordDetailDto dto);

    Integer saveQualificationQueryRecord(QualificationQueryRecordDto dto);

    Integer batchSaveQualificationQueryDetail(List<QualificationQueryDetailDto> list);

}

