/**
 * Project Name:tuia-core-api<br>
 * File Name:AdvertCouponDto.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.dto<br>
 * Date:2016年8月31日下午3:29:19<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.core.api.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;

/**
 * ClassName: AdvertCouponDto <br/>
 * Function: 广告优惠券. <br/>
 * date: 2016年8月31日 下午3:29:19 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class AdvertCouponDto implements Serializable {

    private static final long          serialVersionUID = 1L;

    public static final String               DEFAULT_BTN_TEXT = "马上使用";

    /** 广告券码ID. */
    private Long                       id;

    /** 首页banner图. */
    private String                     bannerPng;

    /** 优惠码类型 1：推广网址 2：可重复使用码 3：普通优惠码. */
    private Integer                    couponType;

    /** 商品名称. */
    private String                     couponName;

    /** 兑换成功文案. */
    private String                     exchangeTips;

    /** 是否审核通过过 true：通过过 false：没有通过过. */
    private boolean                    isCheckPass;

    /** 领取次数限制. */
    private Integer                    limitReceive;

    /** 推广网址. */
    private String                     promoteURL;

    /**
     * 广告主获取用户信息回传链接
     */
    private String promoteBackUserUrl;

    /** 品牌图标. */
    private String                     thumbnailPng;

    /** 是否隐藏. 对特殊应用隐藏使用按钮(0：否，1：是) */
    private boolean                    displayMenu;

    /** 是否为微信券. 是否为微信券(0：否，1：是) (只有code_type=2 or code_type=3时有效) */
    private boolean                    isWeixin;

    /** 按钮文案 */
    private String                     buttonText;

    /** 推广目的 0 非应用下载 1 应用下载 */
    private Integer                     expandTarget;
    /** 安装包名 */
    private String                     packageName;


    /**
     * 应用信息需求-应用名称
     */
    private String appInfoName;
    /**
     * 应用信息需求-应用版本
     */
    private String appInfoVersion;
    /**
     * '应用信息需求-应用开发者
     */
    private String appInfoDeveloper;
    /**
     * 应用信息需求-应用的包体大小
     */
    private String appInfoPkgSize;
    /**
     * 应用信息需求-应用权限H5链接
     */
    private String appInfoPermissionUrl;
    /**
     * 应用信息需求-应用隐私政策H5链接
     */
    private String appInfoPrivacyUrl;

    public String getAppInfoName() {
        return appInfoName;
    }

    public void setAppInfoName(String appInfoName) {
        this.appInfoName = appInfoName;
    }

    public String getAppInfoVersion() {
        return appInfoVersion;
    }

    public void setAppInfoVersion(String appInfoVersion) {
        this.appInfoVersion = appInfoVersion;
    }

    public String getAppInfoDeveloper() {
        return appInfoDeveloper;
    }

    public void setAppInfoDeveloper(String appInfoDeveloper) {
        this.appInfoDeveloper = appInfoDeveloper;
    }

    public String getAppInfoPkgSize() {
        return appInfoPkgSize;
    }

    public void setAppInfoPkgSize(String appInfoPkgSize) {
        this.appInfoPkgSize = appInfoPkgSize;
    }

    public String getAppInfoPermissionUrl() {
        return appInfoPermissionUrl;
    }

    public void setAppInfoPermissionUrl(String appInfoPermissionUrl) {
        this.appInfoPermissionUrl = appInfoPermissionUrl;
    }

    public String getAppInfoPrivacyUrl() {
        return appInfoPrivacyUrl;
    }

    public void setAppInfoPrivacyUrl(String appInfoPrivacyUrl) {
        this.appInfoPrivacyUrl = appInfoPrivacyUrl;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getBannerPng() {
        return bannerPng;
    }

    public void setBannerPng(String bannerPng) {
        this.bannerPng = bannerPng;
    }

    public Integer getCouponType() {
        return couponType;
    }

    public void setCouponType(Integer couponType) {
        this.couponType = couponType;
    }

    public String getCouponName() {
        return couponName;
    }

    public void setCouponName(String couponName) {
        this.couponName = couponName;
    }

    public String getExchangeTips() {
        return exchangeTips;
    }

    public void setExchangeTips(String exchangeTips) {
        this.exchangeTips = exchangeTips;
    }

    public boolean isCheckPass() {
        return isCheckPass;
    }

    public void setCheckPass(boolean isCheckPass) {
        this.isCheckPass = isCheckPass;
    }

    public Integer getLimitReceive() {
        return limitReceive;
    }

    public void setLimitReceive(Integer limitReceive) {
        this.limitReceive = limitReceive;
    }

    public String getPromoteURL() {
        return promoteURL;
    }

    public void setPromoteURL(String promoteURL) {
        this.promoteURL = promoteURL;
    }

    public String getThumbnailPng() {
        return thumbnailPng;
    }

    public void setThumbnailPng(String thumbnailPng) {
        this.thumbnailPng = thumbnailPng;
    }

    public boolean isDisplayMenu() {
        return displayMenu;
    }

    public void setDisplayMenu(boolean displayMenu) {
        this.displayMenu = displayMenu;
    }

    public boolean isWeixin() {
        return isWeixin;
    }

    public void setWeixin(boolean isWeixin) {
        this.isWeixin = isWeixin;
    }

    public String getButtonText() {
        return buttonText;
    }

    public void setButtonText(String buttonText) {
        this.buttonText = buttonText;
    }

    public String getPromoteBackUserUrl() {
        return promoteBackUserUrl;
    }

    public void setPromoteBackUserUrl(String promoteBackUserUrl) {
        this.promoteBackUserUrl = promoteBackUserUrl;
    }

    public Integer getExpandTarget() {
        return expandTarget;
    }

    public void setExpandTarget(Integer expandTarget) {
        this.expandTarget = expandTarget;
    }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
