package cn.com.duiba.tuia.core.api.dto.account.rsp;

import cn.com.duiba.tuia.core.api.statistics.domain.ByDateQueryReq;
import lombok.Data;


import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @description 广告主迁户任务表
 * @author fanjia
 * @date 2021-09-17
 */
@Data
public class AccountChangeTaskDto extends ByDateQueryReq implements Serializable {


    private static final long serialVersionUID = 2235789351401631165L;
    /**
    * id
    */
    private Long id;

    /**
    * 迁户的广告主id
    */
    private Long accountId;

    /**
    * 迁户的广告主名称
    */
    private String accountName;

    /**
    * 老的代理商id
    */
    private Long oldAgentId;

    /**
    * 老的代理商名称
    */
    private String oldAgentName;

    /**
    * 老的代理商级别
    */
    private Integer oldAgentLevel;

    /**
    * 新的代理商id
    */
    private Long newAgentId;

    /**
    * 新的代理商名称
    */
    private String newAgentName;

    /**
    * 新的代理商级别
    */
    private Integer newAgentLevel;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;

    /**
    * 钉钉审批单里提交的迁户类型展示用（非实际迁户类型）
    */
    private String changeType;

    /**
    * 本次迁户成功是第几次迁户
    */
    private Integer changeCount;

    /**
    * 迁户任务当前所处在对一个状态
    */
    private Integer taskState;

    /**
    * 迁户完成时间
    */
    private Date taskFinishTime;

    /**
    * 累加式记录迁户流程中出现的的问题情况，若无则为空
    */
    private String changeRemake;

    /**
    * 任务计划执行时间
    */
    private Date taskScheduledDate;

    /**主体是否变更0没变1变了*/
    private Integer ownerChange;


    public AccountChangeTaskDto() {
    }


}
