package cn.com.duiba.tuia.core.api.enums.compensate;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;
import java.util.stream.Stream;

/**
 * 自动赔付使用状态枚举
 *
 * @author zhangbaiqiang
 * @date 2021/4/27
 */
@Getter
@AllArgsConstructor
public enum AutoCompensateStateEnum {

    INVALID(0, "无效"),
    AUTO_COMPENSATE(1, "自动赔付"),
    OFFLINE_COMPENSATE(2, "线下赔付");

    private final Integer state;
    private final String  desc;

    public static String getDesc(Integer state) {
        return Stream.of(AutoCompensateStateEnum.values())
                .filter(e -> Objects.equals(e.getState(), state))
                .findFirst()
                .map(AutoCompensateStateEnum::getDesc)
                .orElse(null);
    }
}
