package cn.com.duiba.tuia.core.api.enums.rta;

import lombok.Getter;

/**
 * @Author yuquanfeng
 * @Date 2022/9/25
 * @Description 
 * @Param
 * @return
 **/
@Getter
public enum RtaDatSourceEnum {
    /**
     * 百度已安装数据oaid
     */
    SHOUBAI_OAID(1, "百度已安装数据oaid", 1, "tb_rta_brush_device_info"),
    /**
     * 淘宝已安装数据oadi
     */
    TAOBAO_OAID(2, "淘宝已安装数据oaid", 1, "tb_taobao_oaid_device_info"),
    /**
     * 淘宝已安装数据imei
     */
    TAOBAO_IMEI(3, "淘宝已安装数据imei", 2, "tb_taobao_imei_device_info"),
    /**
     * 淘宝已安装数据idfa
     */
    TAOBAO_IDFA(4, "淘宝已安装数据idfa", 3, "tb_taobao_idfa_device_info"),
    /**
     * 天猫已安装数据oaid
     */
    TIANMAO_OAID(5, "天猫已安装数据oaid", 1, "tb_tianmao_oaid_device_info"),
    /**
     * 天猫已安装数据imei
     */
    TIANMAO_IMEI(6, "天猫已安装数据imei", 2, "tb_tianmao_imei_device_info"),
    /**
     * 天猫已安装数据idfa
     */
    TIANMAO_IDFA(7, "天猫已安装数据idfa", 3, "tb_tianmao_idfa_device_info"),
    ;

    private Integer type;

    private String desc;
    /**
     * device类型 1-oaid 2-imei 3-idfa
     *
     */
    private Integer deviceType;
    /**
     * 表名
     */
    private String tableName;

    RtaDatSourceEnum(Integer type, String desc, Integer deviceType, String tableName){
        this.type = type;
        this.desc = desc;
        this.deviceType = deviceType;
        this.tableName = tableName;
    }


    public static String getTableNameByType(Integer type){
        for (RtaDatSourceEnum rtaDatSourceEnum : RtaDatSourceEnum.values()){
            if(rtaDatSourceEnum.getType().equals(type)){
                return rtaDatSourceEnum.getTableName();
            }
        }
        return null;
    }

    public static Integer getDeviceTypeByType(Integer type){
        for (RtaDatSourceEnum rtaDatSourceEnum : RtaDatSourceEnum.values()){
            if(rtaDatSourceEnum.getType().equals(type)){
                return rtaDatSourceEnum.getDeviceType();
            }
        }
        return null;
    }

    public static String getDescByType(Integer type){
        for (RtaDatSourceEnum rtaDatSourceEnum : RtaDatSourceEnum.values()){
            if(rtaDatSourceEnum.getType().equals(type)){
                return rtaDatSourceEnum.getDesc();
            }
        }
        return null;
    }
}
