package cn.com.duiba.tuia.core.api.remoteservice.account;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.CompanyInfoDto;
import com.alibaba.fastjson.JSONObject;

import java.util.List;

@AdvancedFeignClient
public interface RemoteCompanyInfoService {

    /**
     * 新增.
     *
     * @param dto 公司信息
     * @return the int
     */
    Integer insert(CompanyInfoDto dto);

    /**
     *  批量插入
     * @author fanjia
     * @date 2021/8/24 下午5:17
     * @return null
     */
    int batchInsert(List<CompanyInfoDto> dto);

    /**
     * 根据账户id 更新
     */
    Integer updateByAccountId(CompanyInfoDto dto);

    /**
     * 根据账户id 更新广告主更新信息  目前手动更新，其他人不要使用
     */
    Boolean  updateCompanyInfoByAccountId(Long accountId);

    /**
     *  该方法是调用企查查接口不做任何处理
     * 查询企查查的企业工商信息
     * 降级1秒 熔断给null
     *
     * @param businessLicenseId
     * @return
     * @throws Exception
     */
      JSONObject getForQichacha(String businessLicenseId) throws Exception ;

    /**
     * 批量根据账户id 更新  null值就更新null值的接口
     */
    Integer batchUpdateByAccountIdIgnoreNull(List<CompanyInfoDto> dtoList);


    /** 改变企业信息巡查状态*/
    Integer updateCompanyInfoChangeState(Long accountId,Integer state);

    /**
     * 根据公司名称查账户信息
     * @param company
     * @return
     */
    List<CompanyInfoDto> getListByCompany(String company);
}
