package cn.com.duiba.tuia.core.api.remoteservice.advert;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.advert.AdvertDelCheckDto;

import java.util.List;

/**
 * 获取可用广告信息
 */
@AdvancedFeignClient
public interface RemoteValidAdvertService {

    /**
     * 获取可用广告
     * @return
     */
    List<Long> getValidAvertIds();

    /**
     * 获取可用广告配置
     * @return
     */
    List<Long> getValidOrientPkg();

    /**
     * 校验人群包是否被广告使用
     *
     * @param peoplePkgIds
     * @return
     */
    List<AdvertDelCheckDto> getAdvertDelCheckResult(List<String> peoplePkgIds);
}
