package cn.com.duiba.tuia.core.api.remoteservice.app;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.req.app.ReqPageQueryAppFlowStrategyData;
import cn.com.duiba.tuia.core.api.dto.rsp.app.RspAppFlowStrategyPage;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 
 * 新媒体策略配置
 * date: 2017年3月10日 下午2:31:05 <br/>
 *
 * @author chencheng
 * @version
 */
@AdvancedFeignClient
public interface RemoteAppFlowStrategyService {

    /**
     * 查询总数
     *
     * @author chencheng
     * @param req
     * @return
     */
    DubboResult<Integer> selectAppFlowStrategyAmount(ReqPageQueryAppFlowStrategyData req);
    
    /**
     * 分页查询数据
     *
     * @author chencheng
     * @param req
     * @return
     */
    DubboResult<List<RspAppFlowStrategyPage>> selectAppFlowStrategyListByPage(ReqPageQueryAppFlowStrategyData req);

    /**
     * 新分页查询策略
     * @param req
     * @return
     */
    List<RspAppFlowStrategyPage> selectAppFlowStrategyListByPageDws(ReqPageQueryAppFlowStrategyData req);

    /**
     * 新查询媒体策略总数
     * @param req
     * @return
     */
    Integer countAppFlowStrategyListDws(ReqPageQueryAppFlowStrategyData req);
}
