package cn.com.duiba.tuia.core.api.remoteservice.company_dynamic;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.company_dynamic.DuibaCompanyDynamicDto;
import cn.com.duiba.tuia.core.api.dto.company_dynamic.DuibaCompanyDynamicQueryDto;

import java.util.List;

/**
 * @author wangting
 * @version 1.0
 * @ClassName: RemoteDuibaCompanyDynamicService
 * Function: 兑吧集团官网相关信息数据服务
 * Date:     2019/7/3 0003 上午 10:55
 */
@AdvancedFeignClient
public interface RemoteDuibaCompanyDynamicService {

    /**
     * 添加 或者修改 公司动态
     * @param req
     */
    void addOrUpdateDynamic(DuibaCompanyDynamicDto req);

    /**
     *查询
     * @param req
     */
    List<DuibaCompanyDynamicDto> queryList(DuibaCompanyDynamicQueryDto req);

    /**查询
     * @param newsId
     * @param languageVersion
     */
    DuibaCompanyDynamicDto queryById(Long  newsId, String languageVersion);
}
