/**
 * Project Name:manager-domain File Name:GetAdvertiserDataReq.java Package Name:cn.com.duiba.tuia.manager.req
 * Date:2016年5月25日上午9:54:00 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.core.api.statistics.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang.builder.ToStringBuilder;

import javax.validation.constraints.Pattern;
import java.util.List;

/**
 * ClassName:GetAdvertiserDataReq <br/>
 * Function: 查询广告主统计数据请求参数. <br/>
 * Date: 2016年5月25日 上午9:54:00 <br/>
 * 
 * @author Administrator
 * @version
 * @since JDK 1.6
 * @see
 */
@ApiModel("查询广告主统计数据请求参数")
public class GetAdvertiserDataReq extends ByDateQueryReq {

    private static final long serialVersionUID = 8856654767043905735L;

    /** 广告主ID集合(用于模糊查询). */
    @ApiModelProperty(value = "广告主ID集合", hidden = true)
    private List<Long> accountIds;

    /** 代理商ID集合(用于模糊查询). */
    @ApiModelProperty(value = "代理商ID集合", hidden = true)
    private List<Long> agentIds;

    /** 广告主名称. */
    @ApiModelProperty("广告主名称")
    private String     companyName;

    /** 代理商名称. */
    @ApiModelProperty("代理商名称")
    private String     agentCompanyName;

    @ApiModelProperty("1-杭州推啊、2-霍尔果斯推啊，空-总的")
    private Integer            effectiveMainType;

    @ApiModelProperty("活动类型：0-互动广告，1-展示广告 2-激励广告")
    private Integer           activityType;

    private List<Long> testAccountIds;

    /**
     * activityType.
     *
     * @return the activityType
     * @since JDK 1.8
     */
    public Integer getActivityType() {
        return activityType;
    }

    /**
     * activityType.
     *
     * @param activityType the activityType to set
     * @since JDK 1.8
     */
    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    public Integer getEffectiveMainType() {
        return effectiveMainType;
    }

    public void setEffectiveMainType(Integer effectiveMainType) {
        this.effectiveMainType = effectiveMainType;
    }

    /**
     * Gets the companyName.
     *
     * @return the companyName
     */
    public String getCompanyName() {
        return companyName;
    }

    /**
     * Sets the companyName.
     *
     * @param companyName the companyName
     */
    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    /**
     * Gets the agentCompanyName.
     *
     * @return the agentCompanyName
     */
    public String getAgentCompanyName() {
        return agentCompanyName;
    }

    /**
     * Gets the account ids.
     *
     * @return the account ids
     */
    public List<Long> getAccountIds() {
        return accountIds;
    }

    /**
     * Sets the account ids.
     *
     * @param accountIds the account ids
     */
    public void setAccountIds(List<Long> accountIds) {
        this.accountIds = accountIds;
    }

    /**
     * Sets the agent company name.
     *
     * @param agentCompanyName the agent company name
     */
    public void setAgentCompanyName(String agentCompanyName) {
        this.agentCompanyName = agentCompanyName;
    }

    /**
     * Gets the agent ids.
     *
     * @return the agent ids
     */
    public List<Long> getAgentIds() {
        return agentIds;
    }

    /**
     * Sets the agent ids.
     *
     * @param agentIds the agent ids
     */
    public void setAgentIds(List<Long> agentIds) {
        this.agentIds = agentIds;
    }

    public List<Long> getTestAccountIds() {
        return testAccountIds;
    }

    public void setTestAccountIds(List<Long> testAccountIds) {
        this.testAccountIds = testAccountIds;
    }

    @Pattern(regexp = "^$|(consumeTotal|launchCount|exposureCount|efClickCount)",message = "排序只能是consumeTotal|launchCount|exposureCount|efClickCount")
    @Override
    public String getSort() {
        return super.getSort();
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
