package cn.com.duiba.tuia.core.api.dto.advert;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 广告主审核广告落地页列表
 * @author lijicong
 * @since 2021-06-08
 */
@Getter
@Setter
public class AdvertiserCheckAdvertFormDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("")
    private Long id;

    @ApiModelProperty("广告id")
    private Long advertId;

    @ApiModelProperty("落地页id")
    private Long promoteUrlId;

    @ApiModelProperty("落地页地址")
    private String promoteUrl;

    @ApiModelProperty("审核状态，1-未审核，2-审核拒绝，3-审核通过")
    private Integer checkStatus;

    @ApiModelProperty("创建时间")
    private Date gmtCreate;

    @ApiModelProperty("修改时间")
    private Date gmtModified;

    @ApiModelProperty("广告id批量查询")
    private List<Long> advertIdList;

}