package cn.com.duiba.tuia.core.api.dto.compensate;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

import cn.com.duiba.tuia.core.api.dto.BaseDto;

/**
 * 广告赔付DTO
 *
 * @author peanut.huang
 * @date 2019/10/14
 * @since JDK 1.8
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ToString
public class CompensateAdvertDTO extends BaseDto implements Serializable {

    private static final long serialVersionUID = 8605501268164146478L;

    /**
     * 要赔付的日期
     */
    private Date        compensateDate;

    /**
     * 计划id
     */
    private Long        advertId;

    /**
     * 赔付量级
     */
    private Long        compensateLevel;

    /**
     * 赔付金额
     */
    private Long        compensateAmount;

    /**
     * 赔付状态
     */
    private Integer     compensateStatus;

    /**
     * 赔付开关
     */
    private Integer     compensateSwitch;

    /**
     * 赔付开关是否禁用
     */
    private Integer     switchDisable;

    /**
     * 赔付进度
     */
    private String      compensateProgress;

    /**
     * 开启时间
     */
    private Date        openDate;

    /**
     * 结束时间
     */
    private Date        endDate;

    /**
     * 新行业
     */
    private String newTrade;
}
