package cn.com.duiba.tuia.core.api.dto.deviceReport;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

/**
 * 每日设备转化数据表
 * @author lijicong
 * @since 2022-10-28
 */
@Getter
@Setter
public class DeviceConvertDayDto implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("自增id")
    private Long id;

    @ApiModelProperty("入库日期")
    private Date curDate;

    @ApiModelProperty("设备号")
    private String deviceId;

    @ApiModelProperty("设备类型, imei,idfa,oaid")
    private String deviceType;

    @ApiModelProperty("转化时间")
    private Date convertTime;

    @ApiModelProperty("转化类型")
    private Integer backendEffectType;

    @ApiModelProperty("行业")
    private String newTrade;

    @ApiModelProperty("资源标签")
    private String resoureTagName;

    @ApiModelProperty("创建时间")
    private Date gmtCreate;

    @ApiModelProperty("修改时间")
    private Date gmtModified;

}